import time
from tqdm import tqdm
import json
import jsonlines
import numpy as np
from fuzzywuzzy import fuzz
import spacy
import re
nlp = spacy.load("en_core_web_sm")

def read_jsonline(sample_file):
    samples = []
    for line in sample_file.iter():
        samples.append(line)
    return samples


if __name__ == "__main__":
    text_scores = 0.0
    image_scores = 0.0
    group_scores = 0.0
    count = 0
    text_score_file = jsonlines.open('./gpt4_ans/winoground/cb_icl/text_score/test.jsonl', mode='r') 
    image_score_file = jsonlines.open('./gpt4_ans/winoground/cb_icl/image_score/test.jsonl', mode='r') 
    text_score_file = read_jsonline(text_score_file)
    image_score_file = read_jsonline(image_score_file)
    with tqdm(desc='Process', unit='it', total=41) as pbar: 
        with open('./ans2res/winoground/cb_icl/test.jsonl', 'w') as outfile:
            for index in range(41):
                text_sample = text_score_file[index]
                captions = text_sample["labels"]
                chatgpt1 = text_sample["gpt4_score_1"]
                if re.search(re.escape(captions[0].lower()), chatgpt1.lower(), re.I): 
                    text_score1 = 1
                else:
                    text_score1 = 0
                chatgpt2 = text_sample["gpt4_score_2"]
                if re.search(re.escape(captions[1].lower()), chatgpt2.lower(), re.I): 
                    text_score2 = 1
                else:
                    text_score2 = 0

                if text_score1 == 1 and text_score2 == 1:
                    text_score = 1
                else:
                    text_score = 0

                image_sample = image_score_file[index]
                captions = image_sample["explanations"]
                chatgpt1 = image_sample["gpt4_score_1"]
                if re.search(re.escape(captions[0].lower()), chatgpt1.lower(), re.I): 
                    image_score1 = 1
                else:
                    image_score1 = 0
                chatgpt2 = image_sample["gpt4_score_2"]
                if re.search(re.escape(captions[1].lower()), chatgpt2.lower(), re.I): 
                    image_score2 = 1
                else:
                    image_score2 = 0
                if image_score1 == 1 and image_score2 == 1:
                    image_score = 1
                else:
                    image_score = 0
                
                if text_score == 1 and image_score == 1:
                    group_score = 1
                else:
                    group_score = 0
                text_scores += text_score
                image_scores += image_score
                group_scores += group_score
                pbar.set_postfix(text_scores=text_scores / (count + 1), image_scores=image_scores / (count + 1), group_scores=group_scores / (count + 1))
                count = count + 1
                information = {}
                information['id'] = text_sample['id']
                information['images'] = text_sample['images']
                information['labels'] = text_sample['labels']
                information['explanations'] = text_sample['explanations']
                information['tag'] = text_sample['tag']
                information['secondary_tag'] = text_sample['secondary_tag']
                information['num_main_preds'] = text_sample['num_main_preds']
                information['collapsed_tag'] = text_sample['collapsed_tag']
                information['text_score'] = text_score
                information['image_score'] = image_score
                information['group_score'] = group_score
                json.dump(information, outfile)
                outfile.write('\n')
                pbar.update()




